<?php 
   /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";

    // avvio la sessione che servirà dopo per impostare il token di sicurezza
    // o per reindirizzare all'area amministrativa se l'utente è già connesso
    session_start();
    if(isset($_SESSION["geecomAdmin_email"])) {
        header("Location: home.php");
    }
    else {
        $_SESSION["tokenSicurezza"] = sha1(rand(0,100000));
    }

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title> Login a <?php echo $infoGeecom["versione"]; ?></title>

    <?php 
        include "include/cssBaseAreaAmministrativa.php";
    ?>
</head>

<body class="bg-primary">
    <main role="main">
        <div id="login" class="container">
            <div class="card card-container box-shadow-lite fadeInDown">
                <?php 
                    if($impostazioni["attivaFortino"]=="si" && (!isset($_GET["p"]) || $_GET["p"] != $impostazioni["parolaChiaveFortino"]) && !isset($_GET["status"])) { 
                ?>
                        <img class="center-block img-responsive" src="../template/img/fortino.png"  alt="Geecom 4" />
                        <p class="alert alert-danger mt-3 mb-0">Accesso negato: chiave di sicurezza non corretta</p>
                <?php
                    }
                    else { //se la chiave di sicurezza del fortino è corretta oppure non viene usato il fortino stampa il modulo di login
                ?>
                        <img class="img-fluid mb-4" src="../template/img/geecom.svg" alt="Geecom 4"/>
                        <?php 
                            if(isset($_GET["status"])) {
                                if($_GET["status"]==100) {
                                    echo"<p class=\"alert alert-success\">Password inviata, controlla la mail ed effettua di nuovo il login</p>";
                                }
                                else if($_GET["status"]==400) {
                                    echo"<p class=\"alert alert-danger\">Errore: email o password errati</p>";
                                }
                                else if($_GET["status"]==401) {
                                    echo"<p class=\"alert alert-danger\">Errore: il tuo account non è attivo</p>";
                                }
                                else { //status = 444
                                    echo"<p class=\"alert alert-danger\">Errore: Il token di sicurezza non era più valido, riprova ora</p>";
                                }
                            }
                        ?>
                        <form class="form-signin" action="login.php" method="post">
                            <div class="form-group">
                                <input type="email" name="email" id="inputEmail" class="form-control" placeholder="Indirizzo email" required autofocus>
                            </div>
                            <div class="form-group">
                                <input type="password" name="password" id="password" class="form-control" required />
                            </div>
                            <input type="text" class="d-none" name="tokenSicurezza" <?php echo"value=\"{$_SESSION["tokenSicurezza"]}\""; ?> >
                            <button class="btn btn-primary btn-block" type="submit">Accedi</button>
                        </form>
                        <a href="recuperaPassword.php">
                            Password dimenticata?
                        </a>
                <?php
                    }
                ?>
            </div><!-- /card-container -->
        </div><!-- /container --> 
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>
    <!-- abilita popover -->
    <script type="text/javascript">  
		
	function controlloForm() {
		var pass = document.getElementById("password").value;
		var pass2 = document.getElementById("password2").value;
                var cartellaAmministrazione = document.getElementById("cartellaAmministrazione").value;
		if(pass==pass2 && pass!="") {
                    document.formInstallazione.submit();
		}
		else if(pass=="") {
                    alert("Inserisci la password");
		}
                else if(cartellaAmministrazione=="") {
                    alert("La cartella dell'area amministrativa non può essere vuota ");
                }
                else if(cartellaAmministrazione.indexOf(" ")>-1) {
                    alert("Il nome della cartella amministrativa non può contenere spazi");
                }
		else {
                    alert("Le password devono coincidere");
		}
	}
    </script>
    
    <script type="text/javascript"> 		

           $(function(){

                   $("[data-toggle=popover]").popover({
                           html : true,
                           content: function() {
                                   var content = $(this).attr("data-popover-content");
                                   return $(content).children(".popover-body").html();
                           },
                           title: function() {
                                   var title = $(this).attr("data-popover-content");
                                   return $(title).children(".popover-heading").html();
                           }
                   });

           });

            $('body').on('click', function (e) {
                   $('[data-toggle="popover"]').each(function () {
                           //the 'is' for buttons that trigger popups
                           //the 'has' for icons within a button that triggers a popup
                           if (!$(this).is(e.target) && $(this).has(e.target).length === 0 && $('.popover').has(e.target).length === 0) {
                                   $(this).popover('hide');
                           }
                   });
           });

   </script> 
</body>
</html>